/** @file   helpnote.cpp
 * @brief   Implementation of HelpNote - class
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */
 
#include "helpnote.h"
#include "GfxManager.h"
using std::vector;
using std::string;

namespace WeWantWar {

/** Constructor.
 */
HelpNote::HelpNote( int x, int y, int w, int h,
                    const vector<string>& rTextTable ) :
  OverlayItem( x, y, w, h ),
  m_textTable( rTextTable ),
  m_align( ALIGN_LEFT )
{
  m_pFont = GfxManager::storyFont;
  this->updateBackgroundBuffer();
}



/** Destructor.
 */
HelpNote::~HelpNote()
{
}



/** The update method
 */
void HelpNote::update()
{
}



/** Sets the text contents
 */
void HelpNote::setContents( const vector<string>& rTextTable )
{
  m_textTable = rTextTable;
  this->updateBackgroundBuffer();
}



/** Sets the aligning value
 */
void HelpNote::align( Align a )
{
  m_align = a;
  this->updateBackgroundBuffer();
}



/** Returns the aligning value
 */
HelpNote::Align HelpNote::align() const
{
  return m_align;
}



/** Updates the background buffer.
 */
void HelpNote::updateBackgroundBuffer()
{
  BITMAP* pB = this->getBuffer();
  if ( pB == 0 ) {
    return;
  }
  clear_to_color( pB, makecol( 80, 80, 80 ) );
  rect( pB, 0,0, pB->w-1, pB->h-1, makecol(140,140,140) );
  
  if ( m_pFont == 0 ) {
    return;
  }
  
  FONT* pF = m_pFont->al_FONT();
  int c = makecol( 230,230, 0 );
  for (int i=0; i < m_textTable.size(); i++ ) {
    int y = i * text_height( pF ) + 2;
    textout_ex( pB, pF, m_textTable.at(i).c_str(), 2,y, c, -1 );
  }
}

} // end of namespace
